//
//  VDTextFieldWithDropDown.m
//  DropDownList
//
//  Created by Claus Richter on 4/21/14.
//  Copyright (c) 2014 Claus Richter. All rights reserved.
//

#import "VDTextFieldWithDropDown.h"
#import "VDTableViewForPopover.h"

@implementation VDTextFieldWithDropDown {
    bool editing_;
    CGFloat keyboardHeight_;
    UIPopoverController* popover_;
    VDTableViewForPopover* tableViewForPopover_;
}

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
        [self addTarget:self action:@selector(editingDidBegin) forControlEvents:UIControlEventEditingDidBegin];
        [self addTarget:self action:@selector(editingDidEndOnExit) forControlEvents:UIControlEventEditingDidEndOnExit];
        [self addTarget:self action:@selector(editingDidEnd) forControlEvents:UIControlEventEditingDidEnd];
    }
    return self;
}

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super initWithCoder:aDecoder];
    if (self) {
        // Initialization code
        [self addTarget:self action:@selector(editingDidBegin) forControlEvents:UIControlEventEditingDidBegin];
        [self addTarget:self action:@selector(editingDidEndOnExit) forControlEvents:UIControlEventEditingDidEndOnExit];
        [self addTarget:self action:@selector(editingDidEnd) forControlEvents:UIControlEventEditingDidEnd];
    }
    return self;
}

-(void) noticeShowKeyboard:(NSNotification *)inNotification {
    CGSize keyboardSize = [[[inNotification userInfo] objectForKey:UIKeyboardFrameBeginUserInfoKey] CGRectValue].size;
    keyboardHeight_ = keyboardSize.height > keyboardSize.width ? keyboardSize.width : keyboardSize.height; // In landscape the width and height might be swapped
    if (self.editing) {
        [self showPopover];
    }
}

- (void)showPopover {
    if (!_items.count) return;
    
    if (!popover_) {
        tableViewForPopover_ = [[VDTableViewForPopover alloc] init];
        tableViewForPopover_.linkedTextField = self;
        tableViewForPopover_.fixedTable = _fixed;
        tableViewForPopover_.items = self.items; // Make it reload th eitems and clear past selection
        popover_ = [[UIPopoverController alloc] initWithContentViewController:tableViewForPopover_];
        popover_.delegate = self;
    }
    tableViewForPopover_ = (VDTableViewForPopover*)popover_.contentViewController;
    tableViewForPopover_.items = self.items; // Make it reload th eitems and clear past selection
    CGFloat height = MAX(60,MIN(tableViewForPopover_.height, ([UIApplication sharedApplication].keyWindow.frame.size.height - keyboardHeight_)));
    popover_.popoverContentSize = CGSizeMake(self.frame.size.width + 40, height);
    [popover_ presentPopoverFromRect:self.frame inView:self.superview permittedArrowDirections:UIPopoverArrowDirectionLeft|UIPopoverArrowDirectionRight animated:YES];
}

- (void)dismissPopover {
    _items = tableViewForPopover_.items;
    [popover_ dismissPopoverAnimated:YES];
    [self sendActionsForControlEvents:UIControlEventEditingDidEndOnExit];
}

- (void)addItem:(NSString*)string {
    if (string.length != 0 && ![_items containsObject:string]) {
        NSMutableArray* array = [NSMutableArray arrayWithArray:_items];
        [array addObject:string];
        _items = [array sortedArrayUsingSelector:@selector(compare:)];
        tableViewForPopover_.items = _items;
    }
}

#pragma mark- UIPopoverControllerDelegate

- (void)popoverControllerDidDismissPopover:(UIPopoverController *)popoverController {
    _items = tableViewForPopover_.items;
    [self resignFirstResponder];
}

#pragma mark- Actios

- (void)editingDidBegin {
    NSNotificationCenter *center = [NSNotificationCenter defaultCenter];
    [center addObserver:self selector:@selector(noticeShowKeyboard:) name:UIKeyboardDidShowNotification object:nil];
}

- (void)editingDidEndOnExit {
    [popover_ dismissPopoverAnimated:YES];
    [self addItem:self.text];
}

- (void)editingDidEnd {
    [popover_ dismissPopoverAnimated:YES];
    [self addItem:self.text];
    [self sendActionsForControlEvents:UIControlEventEditingDidEndOnExit];
    if (_dropDownDelegate) {
        [_dropDownDelegate dropDownSelectionChanged:self];
    }
}

@end
